
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1212.C - Message 1212 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1212 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1212.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:58   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:46:52   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:34   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 10:11:16   COLEJ
//   Repositioned sequence number up one.
//   
//   
//      Rev 1.0   13 May 1996 14:53:06   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>
#include <stdio.h>
#include <conio.h>

#include "gentypes.h"
#include "ztypes.h"
#include "zcons.h"
#include "util.h"   
#include "labmon.h"
#include "display.h"

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1212 message from the ZMsgBuf.
//
void Dec1212(tMSGBUF *ZMsgBuf, tMSG1212 *Msg)
{
  
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1212 message in the ZMsgBuf. 
//
void Bld1212(tMSGBUF *ZMsgBuf, tMSG1212 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                   , ZMsgBuf, 1);   // message preamble
   PutShort  (1212                     , ZMsgBuf, 2);   // message number
   PutShort  (2                        , ZMsgBuf, 3);   // message length 
   PutShort  (ANREQ                    , ZMsgBuf, 4);   // message ack/nack request
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1212 message from the ZMsgBuf.
//
void Show1212(tMSG1212 *Msg)
{
   char    Buf[80] = "";  
   float   ElevationMask = 0;
   
   // convert values
   ElevationMask = (float) (Msg->ElevationMask / 1E+04 * R2D);
   
   // perform special processing for output

   // output the data items   
   sprintf(Buf,"%05d"  ,Msg->SequenceNumber       );ShowText(Buf,TIMR+ 6,TIMC+ 4);
   sprintf(Buf,"%4.1f" ,ElevationMask             );ShowText(Buf,DOPR   ,DOPC+ 7);
}                                                     
                                             
                                             
                                             
                                             
                                       
